#include <p30fxxxx.h>
#include <incap.h>

/********************************************************************
*    Function Name:  ConfigIntCapture1                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture1(unsigned int config)
{
    IFS0bits.IC1IF = 0;                    /* Clear IF bit */
    IPC0bits.IC1IP = (config &0x0007);     /*assigning Interrupt Priority
                                                    to IPC Register */
    IEC0bits.IC1IE = (config &0x0008) >> 3;/*assiging Interrupt Enable/
                                                        Disable.   */   
}
